{*************************************************************
**************************************************************
*   Componente TBuscador  (Mdulo del Thread o Hilo)         *
*   Objetivo: Busqueda de archivos con multiseleccin de     *
*             rutas. Ejemplo sobre el uso de Hilos           *
*             Captulo V de la Serie Threads                 *
*                                                            *
*   Autor: Salvador Jover      mailto: s.jover@wanadoo.es    *
*          Jose Manuel Navarro mailto:jmnavarro@lexnova.es   *
*                                                            *
*   Revista Sintesis N 15  http://www.GrupoAlbor.com/       *
**************************************************************
**************************************************************
* Este componente debe ser tomado como un ejemplo, y no esta *
* por ello libre de errores; por lo que, como autores, no    *
* no podemos garantizar ni recomendar su uso fuera de lo que *
* establece el aprendizaje.                                  *
* As pues, deben establecerse siempre las suficientes       *
* reservas y cautelas a tal efecto. Su uso es libre.         *
**************************************************************}
{ OBJETIVOS DEL COMPONENTE:
   Bsqueda de archivos mediante mltiples hilos: nico hilo por
   ruta, con creacin de hilo para cada ruta.
   Permite la busqueda en unidades de red conectadas a la nuestra.
   Admite el uso de comodines '*' y '?'}

{NOTA DE ATENCION SOBRE SU USO:
  En esta fase de diseo del componente, no debe ser usado aceptando
  como padre (Parent) un componente que no sea un TForm. De no hacerlo
  as, se debera activar el evento OnCloseQuery del formulario y antes
  de que sea cerrado, proceder a Cancelar la ejecucin de la busqueda
  mediante el mtodo Cancel, para as evitar una posible excepcin

  Debe ser incluido un solo buscador por Form}

  {ESQUEMA DEL ALGORITMO}
  //************************************************
  {PETICION DEL USUARIO (RUTA A, RUTA B)
       [RUTA A CONTIENE RUTA AA RUTA AB]
       [RUTA B CONTIENE RUTA BA]

     BUSCADOR------- CREA -->  THILOBUSQUEDA (RUTA A) ------CREA-----> THILOBUSQUEDA (RUTA AA)-----> RESULTADOS   (SI/NO) ----------- SI ------> LISTA RESULTADOS
                        |                                     |
                        |                                     -------> THILOBUSQUEDA (RUTA AB)-----> RESULTADOS   (SI/NO) ----------- SI ------> LISTA RESULTADOS
                        |                                     |
                        |                                     -------------------------------------> RESULTADOS   (SI/NO) ----------- SI ------> LISTA RESULTADOS
                        |
                        ---->  THILOBUSQUEDA (RUTA B) ------CREA-----> THILOBUSQUEDA (RUTA BA)-----> RESULTADOS   (SI/NO) ----------- SI ------> LISTA RESULTADOS
                                                              |
                                                              -------------------------------------> RESULTADOS   (SI/NO) ----------- SI ------> LISTA RESULTADOS


  //************************************************}

unit HiloBusqueda;

interface

uses
  Windows, Messages, SysUtils, Classes, Dialogs, comctrls, stdctrls, Buscador;

const

  // Mensajes de comunicacin entre TBuscador e THiloBusqueda
  // -La comunicacin se produce siempre desde sentido del hilo al buscador-
  // Ver el significado en el mdulo Buscador.pas
  //
   BA_INCPOS =  WM_USER + 1000;
   BA_INCMAX =  WM_USER + 1001;

   RE_NUMITEM = WM_USER + 1002;
   RE_SELECT  = WM_USER + 1003;
   RE_ADD     = WM_USER + 1004;
   RE_DEL     = WM_USER + 1005;

   AR_ADD     = WM_USER + 1006;

   BU_ABORT   = WM_USER + 1007;
   BU_END     = WM_USER + 1009;

type

  TBusqueda = class(TThread)
  private
    fNuevaBusqueda: PNodo;   // puntero a estructura de nodo
    fNodoPadre:   TTreeNode; // nodo padre de nuestro nodo actual
    fBuscador:    TBuscador; // componente buscador que inicia la ejecucin
    fRuta:        string;    // ruta a buscar
    fCarpetaHilo: string;    // ruta (variable auxiliar)
    fSubcarpetas: boolean;   // hay subcarpetas?
    fNodo:        TTreeNode; // apunta al nodo del arbol de resultados actual
    fResultado:   boolean;   // hay coincidencia en la busqueda?
                             //Se ha encontrado archivos en esa carpeta
    procedure OnEnd(Sender: TObject); // al finalizar su ejecucin
  public
    constructor Create(const ABuscador: TBuscador; const ANodoPadre: TTreeNode;
                       const ARuta: string; const ASubcarpetas: boolean); reintroduce; overload;
    procedure Execute; override;   // Mtodo execute de la clase TThread
  end;

var
   // seccin crtica. Ver primeros articulos de la serie sobre el uso
   // y la necesidad de secciones crticas y otros objetos del sistema
   // operativo como semaforos, mutex, etc...
   FCriticalLista: TRTLCriticalSection;

implementation

{TBusqueda}


//--------------------------------------------------------------------
// Nombre    : constructor Create
// Objetivo  : Creacin del componente.
// Comentario: Se parametriza su creacin.
//             Parmetros: ABuscador ----> Buscador
//                         ANodoPadre----> Nodo padre de la actual bsqueda
//                         ARuta---------> Ruta + Fichero a buscar
//                         ASubcarpetas--> Debe descender en la bsqueda?
//             Sin el nodo padre no nos sera posible montar la estructura
//             de arbol.
//             El procedimiento SetCarpeta se justifica por recibir en el
//             parmetro ARuta, toda la cadena conteniendo el fichero y la
//             ruta completa. Entonces, nada ms ser creado el objeto, debemos
//             separar ambas.
//
constructor TBusqueda.Create(const ABuscador: TBuscador; const ANodoPadre: TTreeNode;
                             const ARuta: string; const ASubcarpetas: boolean);

            procedure SetCarpeta;
            var
               pi, pf, PRuta: PChar;
            begin
               PRuta := PChar(FRuta);
               pf    := StrRScan(PRuta, '\');
               if pf = nil then
                  FCarpetaHilo := FRuta
               else begin
                  pf^ := #0;
                  try
                     pi := StrRScan(PRuta, '\');
                     if pi = nil then begin
                        FCarpetaHilo := StrPas(PRuta);
                     end
                     else begin
                        Inc(pi);
                        FCarpetaHilo := StrPas(pi);
                     end;
                 finally
                     pf^ := '\';
                 end;
              end;
           end; //endProcedureSetCarpeta;

begin
   inherited Create(true);     // se crea inicialmente suspendido
   FNodoPadre:= ANodoPadre;
   {Nota de inters:
    La primera vez que se crea el objeto TBusqueda para cada una de
    las bsquedas, el nodo padre siempre vale nil}
   FBuscador:= ABuscador; // apunta al buscador
   FSubcarpetas:= ASubcarpetas;
   FRuta:= ARuta;      // ruta + nombre del fichero
   SetCarpeta;                  // manipulacin del parametro ARuta
   {* Sera interesante, establecer algn punto de parada en este
      procedimiento, para analizar el desglose de la ruta que hace.}
   Self.OnTerminate:= Self.OnEnd; // al finalizar ejecutar OnEnd
   Self.FreeOnTerminate:= True;  // ser liberado automticamente
end;


//--------------------------------------------------------------------
// Nombre    : procedure Execute
// Objetivo  : Ejecucin del algoritmo de bsqueda
// Comentario: Ver comentarios en el artculo
//
procedure TBusqueda.Execute;
var
   FindData:     WIN32_FIND_DATA;
   SearchHandle: THandle;
   Hay:          boolean;
   ruta:         array[0..MAX_PATH-1] of char;
   archivo:      array[0..MAX_PATH-1] of char;
   i:            integer;
   RutaArg:      array[0..MAX_PATH-1] of char;
   FMiNodo:      PNodo;
   carpeta:      PChar;
   ultimo:       TListItem;
begin
   // NO DEBEMOS ENTRAR EN EL ALGORITMO SI SE HA CANCELADO LA BUSQUEDA
   // ESTO ES MUY IMPORTANTE !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
   if Terminated or (fBuscador.Estado = esInactivo) then Exit;

   EnterCriticalSection(FCriticalLista);
   try
    //fBuscador.ArbolResultados.Items.BeginUpdate;
    //try
         {NOTA ACLARATORIA
          Si se vuelve al momento en que el componente buscador aade
          los componmentes THiloBusqueda a la lista de Hilos, se ver
          que ahora tenemos que discriminar aquellos que ya han sido
          aadidos, que son los que no tienen padre, ya que estos han
          sido aadidos por el buscador.
          Es necesario as para que se ejecute correctamente el algoritmo}
         if (fNodoPadre = nil) and (Not Terminated) then begin
            fNodo :=  TTreeNode(fBuscador.Perform(AR_ADD, 0, Integer(fCarpetaHilo)));
         end
         else begin
            if Not Terminated then
               fNodo :=  TTreeNode(FBuscador.Perform(AR_ADD, Integer(fNodoPadre), Integer(fCarpetaHilo)));
         end;
         fNodo.ImageIndex    := 0;
         fNodo.SelectedIndex := fNodo.ImageIndex;
         // cada vez que se crea un hilo, es que estamos en una nueva carpeta
    //finally
      //fBuscador.ArbolResultados.Items.EndUpdate;
    //end;
   finally
      LeaveCriticalSection(FCriticalLista);
   end;


   Hay:= false;
   carpeta := PChar(FRuta);

   // busca en cada una de las subcarpetas (si procede)
   if FSubcarpetas and (not Terminated) then begin
      ZeroMemory(@ruta, MAX_PATH);
      ZeroMemory(@archivo, MAX_PATH);
      // Me quedo con la ruta slamente.
      for i := StrLen(carpeta) - 1 downto 1 do begin
         if carpeta[i] = '\' then begin
            StrLCopy(ruta, carpeta, i + 1);
            StrCopy(archivo, PChar(Integer(@carpeta[i]) + 1));
            break;
         end;
      end;
      StrCat(ruta, '*.*');
      SearchHandle := FindFirstFile(ruta, FindData);
      if SearchHandle <> INVALID_HANDLE_VALUE then begin

      // Se itera en la carpeta actual buscando subcarpetas
         repeat
            if Terminated then exit;
            // si es carpeta, pongo el progreso y creo nuevo hilo
            if (FindData.dwFileAttributes and FILE_ATTRIBUTE_DIRECTORY <> 0) and
               (FindData.cFileName[0] <> '.') then begin
               ZeroMemory(@RutaArg, MAX_PATH);
               StrLCopy(RutaArg, ruta, StrLen(ruta) - 3);
               StrCat(RutaArg, FindData.cFileName);
               StrCat(RutaArg, '\');
               StrCat(RutaArg, archivo);

               EnterCriticalSection(FCriticalLista);
               try
                  New(FMiNodo);
                  With FMiNodo^ do begin
                     NBuscador:= FBuscador;
                     NNodo:= FNodo;
                     StrCopy(NArgumentos, RutaArg);
                     NDesciende:= True;
                  end;
                  fListaNodos.Add(FMiNodo);
                  if not terminated then fBuscador.Perform(BA_INCMAX, 0, 0);
               finally
                  LeaveCriticalSection(FCriticalLista);
               end;

            end;
         until not FindNextFile(SearchHandle, FindData) and not Terminated;

         // error en algn paso de la bsqueda
         if GetLastError <> ERROR_NO_MORE_FILES then begin
            Windows.FindClose(SearchHandle);
            FResultado := false;
            RaiseLastWin32Error;
         end;
         Windows.FindClose(SearchHandle);
      end; //endIfSearchHandle <> INVALID_HANDLE_VALUE
   end;
   // busco el archivo en la carpeta actual
   SearchHandle := FindFirstFile(carpeta, FindData);
   if SearchHandle <> INVALID_HANDLE_VALUE then begin
      ultimo := nil;
      // Se itera en la carpeta actual
      repeat
         // si encuentro algo, inserto el resultado (sincronizado)
         if not ((FindData.dwFileAttributes and FILE_ATTRIBUTE_DIRECTORY <> 0) or
                (FindData.cFileName[0] = '.')) then begin
            EnterCriticalSection(FCriticalLista);
            try
               if not Terminated then ultimo:=  TListItem(FBuscador.Perform(RE_NUMITEM, 0, 0));
               ultimo.Caption := ExtractFilePath(carpeta) + FindData.cFileName;
            finally
               LeaveCriticalSection(FCriticalLista);
            end;
            Hay := true;
         end;
      until not FindNextFile(SearchHandle, FindData) and not Terminated;

      if hay and (ultimo <> nil) and (not Terminated) then
         FBuscador.Perform(RE_SELECT, Integer(Ultimo), 0);
      //
      // error en algn paso de la bsqueda
      //
      if GetLastError <> ERROR_NO_MORE_FILES then begin
         Windows.FindClose(SearchHandle);
         FResultado := false;
         RaiseLastWin32Error;
      end;
   end;
   FResultado := Hay;   // finalmente devolvemos el resultado
end;


//--------------------------------------------------------------------
// Nombre    : procedure OnEnd
// Objetivo  : Finalizacin de la ejecucin del hilo THiloBusqueda
// Comentario: Si la lista de nodos ha sido eliminada por el mtodo
//             cancel, saltar el procedimiento, evitando las
//             excepciones que se produciran por el acceso a la
//             barra y al rbol
//
procedure TBusqueda.OnEnd(Sender: TObject);
var
   Busqueda : TBusqueda;
   tmp_Busqueda: PNodo;
begin
   if Assigned(FListaNodos) and (fBuscador.Estado <> esInactivo) then begin
      // si quedan nodos en la lista de nodos global
      if FListaNodos.Count > 0 then begin
         tmp_Busqueda:= FListaNodos.Items[0];  // elegimos el primero de ellos
         // para crear un nuevo objeto TBusqueda que siga buscando y encontrando nuevos nodos
         with tmp_Busqueda^ do
            Busqueda := TBusqueda.Create(NBuscador, NNodo, NArgumentos, NDesciende);
         // Le entregamos un puntero a su nodo para que al finalizar pueda destruirlo
         Busqueda.fNuevaBusqueda:= tmp_Busqueda;
         if FNodoPadre <> nil then
            FBuscador.Perform(RE_ADD, Integer(Busqueda), 0); //aado thread a lista
         Busqueda.Resume;  // ya puedo lanzar su ejecucin
         // incremento la posicin de la barra
         fBuscador.Perform(BA_INCPOS, 0, 0);
         // y destruyo el item para que corran una posicin en sus lugares
         // y el que estaba en el lugar 1 pase ahora al 0 y sea el siguiente
         // en ser escogido por el hilo creado ahora.
         fListaNodos.Delete(0);
         // destruimos la memoria reservada dinamicamente en el mtodo execute
         if Self.fNuevaBusqueda <> nil then  begin
            Dispose(Self.fNuevaBusqueda);
            Self.fNuevaBusqueda:= nil;
         end;
      end;
      // notificamos en el arbol si hemos encontrado ficheros coincidentes
      if fResultado then begin
         fNodo.Text := FCarpetaHilo + ': fichero(s) encontrado(s).';
         fNodo.ImageIndex := 2;
      end
      else begin
         fNodo.Text := FCarpetaHilo + ': No contiene el fichero buscado.';
         fNodo.ImageIndex := 1;
      end;
      // y borramos el hilo de la lista de hilos
      if fBuscador.Estado <> esInactivo then fBuscador.Perform(RE_DEL, Integer(Self), 0);
   end;
end;


initialization

   InitializeCriticalSection(FCriticalLista);

finalization

   DeleteCriticalSection(FCriticalLista);

end.
